/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl.structure;

import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.tool.collection.KeepOrderSet;

public interface Key<T extends Fromable, ID> {
    public static <T extends Fromable, ID> KeyBuilder<T, ID> from(T table) {
        return new KeyBuilder(table, null);
    }

    public static <T extends Fromable, ID> Key<T, ID> ofSingleColumn(JoinLink<T, ID> column) {
        return new KeySupport<T, ID>((Fromable)column.getOwner(), new KeepOrderSet((Object[])new JoinLink[]{column})){

            @Override
            public boolean isComposed() {
                return false;
            }
        };
    }

    public T getTable();

    public KeepOrderSet<? extends JoinLink<T, ?>> getColumns();

    public boolean isComposed();

    public static class KeySupport<T extends Fromable, ID>
    implements Key<T, ID> {
        private final T table;
        private final KeepOrderSet<JoinLink<T, ?>> columns;

        private KeySupport(T table) {
            this(table, new KeepOrderSet());
        }

        private KeySupport(T table, KeepOrderSet<? extends JoinLink<T, ?>> columns) {
            this.table = table;
            this.columns = columns;
        }

        @Override
        public T getTable() {
            return this.table;
        }

        @Override
        public KeepOrderSet<JoinLink<T, ?>> getColumns() {
            return this.columns;
        }

        private void addColumn(JoinLink<T, ?> column) {
            this.columns.add(column);
        }

        @Override
        public boolean isComposed() {
            return this.columns.size() == 1;
        }

        /* synthetic */ KeySupport(Fromable x0, KeepOrderSet x1, 1 x2) {
            this(x0, x1);
        }

        /* synthetic */ KeySupport(Fromable x0, 1 x1) {
            this(x0);
        }
    }

    public static class KeyBuilder<T extends Fromable, ID> {
        private final KeySupport<T, ID> keySupport;

        private KeyBuilder(T table) {
            this.keySupport = new KeySupport((Fromable)table, null);
        }

        public KeyBuilder<T, ID> addColumn(JoinLink<T, ?> column) {
            ((KeySupport)this.keySupport).addColumn(column);
            return this;
        }

        public Key<T, ID> build() {
            return this.keySupport;
        }

        /* synthetic */ KeyBuilder(Fromable x0, 1 x1) {
            this(x0);
        }
    }
}

